`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 01/05/2018 04:24:09 PM
// Design Name: 
// Module Name: top
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////


module top(
    input clk,
    input [15:0] sw,
    input btnU,             // reset
    output [15:0] led
    );
    
    //
    // turn the FSM on using sw[15];
    //
    wire enable = sw[15];
    // 
    // let's say we want 1024 times the clock period for period of the output signal
    //
    // for the "on" and "off" registers, we will modulate them using a large register.
    // so full scale 100% duty factor will be ON='h3FF and OFF = 0, so the calculation
    // we need is: 
    //
    //
    // now make the counters and the output and the FSM
    //
    reg [9:0] count_on, count_off;
    reg OUT;
    reg [9:0] on, off;
    reg [7:0] change_width;
    wire [7:0] sw8 = sw[7:0];
    wire [7:0] beats = (sw8 == 8'h0 ? 8'hFF : sw8);
    reg count_down;         // 0=increment, 1=decrement
    localparam [1:0] WAIT=0, ON=1, OFF=2, CHANGE=3;
    reg [1:0] state;
    always @ (posedge clk) 
        if (btnU) begin
            state <= WAIT;
            OUT <= 0;
            on <= 0;
            off <= 'hFFFF;
            change_width <= 0;
            count_down <= 0;
        end
        else case (state)
            WAIT: begin
                OUT <= 0;
                count_on <= 0;
                count_off <= 0;
                on <= 0;
                count_down <= 0;
                change_width <= 0;
                if (enable) state <= ON;
                else state <= WAIT;
            end
            ON: begin
                OUT <= 1;
                count_off <= 0;
                count_on <= count_on + 1;
                if (count_on == on) state <= OFF;
                else state <= ON;
            end
            OFF: begin
                OUT <= 0;
                count_on <= 0;
                count_off <= count_off + 1;
                if (count_off == off) state <= CHANGE;
                else state <= OFF;
            end
            CHANGE: begin
                //
                // in this state we check to see if it's time to change the on/off percentage
                //
                change_width <= change_width + 1;
                if (change_width == beats) begin
                    change_width <= 0;
                    if (count_down) begin
                        on <= on - 1;
                        off <= off + 1;
                        if (on == 10'h001) count_down <= 0;
                    end
                    else begin
                        on <= on + 1;
                        off <= off - 1;
                        if (on == 10'h3FE) count_down <= 1;
                    end
                 end
                 if (enable) state <= ON;
                 else state <= WAIT;
            end
            default: begin
                count_on <= 0;
                count_off <= 0;
                on <= 0;
                count_down <= 0;
                change_width <= 0;
                state <= WAIT;
            end
        endcase
    //
    // now drive the output onto led[15]
    //
    assign led = {OUT,5'h0,on[9:0]};
endmodule
